#include "stdafx.h"
#include "win_demo.h"
#include "DialogMotionAlarm.h"
#include "afxdialogex.h"
#include "sdks.h"
#include "common_struct.h"
#include "perser_json.h"
#include "pack_json.h"

extern int m_handle;
extern int m_chn_option;
IMPLEMENT_DYNAMIC(CDialogMotionAlarm, CDialogEx)

CDialogMotionAlarm::CDialogMotionAlarm(CWnd* pParent /*=NULL*/)
	: CDialogEx(IDD_DIALOG_MOTION_ALARM, pParent)
{

}

CDialogMotionAlarm::~CDialogMotionAlarm()
{
}

void CDialogMotionAlarm::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_EDIT_MOT_INTERVAL, m_mot_alarm_interval);
	DDX_Control(pDX, IDC_COMBO_MOT_SENSITIVITY, m_mot_sensitivity);
	DDX_Control(pDX, IDC_COMBO_ALARM_DATE, m_mot_alarm_week);
	DDX_Control(pDX, IDC_EDIT_ALARM_START_TIME_H1, m_start_time_h1);
	DDX_Control(pDX, IDC_EDIT_ALARM_START_TIME_M1, m_start_time_m1);
	DDX_Control(pDX, IDC_EDIT_ALARM_END_TIME_H1, m_end_time_h1);
	DDX_Control(pDX, IDC_EDIT_ALARM_END_TIME_M1, m_end_time_m1);
	DDX_Control(pDX, IDC_EDIT_ALARM_START_TIME_H2, m_start_time_h2);
	DDX_Control(pDX, IDC_EDIT_ALARM_START_TIME_M2, m_start_time_m2);
	DDX_Control(pDX, IDC_EDIT_ALARM_END_TIME_H2, m_end_time_h2);
	DDX_Control(pDX, IDC_EDIT_ALARM_END_TIME_M2, m_end_time_m2);
	DDX_Control(pDX, IDC_EDIT_ALARM_START_TIME_H3, m_start_time_h3);
	DDX_Control(pDX, IDC_EDIT_ALARM_START_TIME_M3, m_start_time_m3);
	DDX_Control(pDX, IDC_EDIT_ALARM_END_TIME_H3, m_end_time_h3);
	DDX_Control(pDX, IDC_EDIT_ALARM_END_TIME_M3, m_end_time_m3);
	DDX_Control(pDX, IDC_EDIT_ALARM_START_TIME_H4, m_start_time_h4);
	DDX_Control(pDX, IDC_EDIT_ALARM_START_TIME_M4, m_start_time_m4);
	DDX_Control(pDX, IDC_EDIT_ALARM_END_TIME_H4, m_end_time_h4);
	DDX_Control(pDX, IDC_EDIT_ALARM_END_TIME_M4, m_end_time_m4);
	DDX_Control(pDX, IDC_EDIT_ALARM_START_TIME_H5, m_start_time_h5);
	DDX_Control(pDX, IDC_EDIT_ALARM_START_TIME_M5, m_start_time_m5);
	DDX_Control(pDX, IDC_EDIT_ALARM_END_TIME_H5, m_end_time_h5);
	DDX_Control(pDX, IDC_EDIT_ALARM_END_TIME_M5, m_end_time_m5);
	DDX_Control(pDX, IDC_EDIT_ALARM_START_TIME_H6, m_start_time_h6);
	DDX_Control(pDX, IDC_EDIT_ALARM_START_TIME_M6, m_start_time_m6);
	DDX_Control(pDX, IDC_EDIT_ALARM_END_TIME_H6, m_end_time_h6);
	DDX_Control(pDX, IDC_EDIT_ALARM_END_TIME_M6, m_end_time_m6);
	DDX_Control(pDX, IDC_EDIT_ALARM_START_TIME_H7, m_start_time_h7);
	DDX_Control(pDX, IDC_EDIT_ALARM_START_TIME_M7, m_start_time_m7);
	DDX_Control(pDX, IDC_EDIT_ALARM_END_TIME_H7, m_end_time_h7);
	DDX_Control(pDX, IDC_EDIT_ALARM_END_TIME_M7, m_end_time_m7);
	DDX_Control(pDX, IDC_EDIT_ALARM_START_TIME_H8, m_start_time_h8);
	DDX_Control(pDX, IDC_EDIT_ALARM_START_TIME_M8, m_start_time_m8);
	DDX_Control(pDX, IDC_EDIT_ALARM_END_TIME_H8, m_end_time_h8);
	DDX_Control(pDX, IDC_EDIT_ALARM_END_TIME_M8, m_end_time_m8);
}


jy_dev_mot_alarm_param_list_t mot_alarm_param_list = { 0 };
jy_dev_show_schedule_time_list_t mot_schedule_time_list = { 0 };
BOOL CDialogMotionAlarm::OnInitMotionAlarm()
{
	char *p_result = NULL;
	int nRet = 0;
	CString strins;
	nRet = sdks_get_mot_param(m_handle, m_chn_option, &p_result);
	if (0 == nRet)
	{
		memset(&mot_alarm_param_list, 0, sizeof(jy_dev_mot_alarm_param_list_t));
		json_perser_mot_alarm_original(p_result, &mot_alarm_param_list);
		((CButton*)GetDlgItem(IDC_CHECK_MOT_ALARM_FLAG))->SetCheck(0);
		if (mot_alarm_param_list.mot_alarm_list[0].mot_source_param.enable_flag)
		{
			((CButton*)GetDlgItem(IDC_CHECK_MOT_ALARM_FLAG))->SetCheck(1);
		}
		((CButton*)GetDlgItem(IDC_CHECK_MOT_ANALYSIS_FLAG))->SetCheck(0);
		if (mot_alarm_param_list.mot_alarm_list[0].mot_source_param.mot_analysis_flag)
		{
			((CButton*)GetDlgItem(IDC_CHECK_MOT_ANALYSIS_FLAG))->SetCheck(1);
		}
		strins.Format(_T("%d"), mot_alarm_param_list.mot_alarm_list[0].mot_source_param.alarm_interval);
		m_mot_alarm_interval.SetWindowTextA(strins);
		m_mot_sensitivity.ResetContent();
		m_mot_sensitivity.InsertString(0, TEXT("1"));
		m_mot_sensitivity.InsertString(1, TEXT("2"));
		m_mot_sensitivity.InsertString(2, TEXT("3"));
		m_mot_sensitivity.InsertString(3, TEXT("4"));
		m_mot_sensitivity.InsertString(4, TEXT("5"));
		m_mot_sensitivity.InsertString(5, TEXT("6"));
		m_mot_sensitivity.InsertString(6, TEXT("7"));
		m_mot_sensitivity.InsertString(7, TEXT("8"));
		m_mot_sensitivity.InsertString(8, TEXT("9"));
		m_mot_sensitivity.InsertString(9, TEXT("10"));
		m_mot_sensitivity.SetCurSel(mot_alarm_param_list.mot_alarm_list[0].mot_source_param.mot_detect_param.sensitivity - 1);
		m_mot_alarm_week.ResetContent();
		m_mot_alarm_week.InsertString(0, TEXT("Sun"));
		m_mot_alarm_week.InsertString(1, TEXT("Mon"));
		m_mot_alarm_week.InsertString(2, TEXT("Tue"));
		m_mot_alarm_week.InsertString(3, TEXT("Wed"));
		m_mot_alarm_week.InsertString(4, TEXT("Thur"));
		m_mot_alarm_week.InsertString(5, TEXT("Fri"));
		m_mot_alarm_week.InsertString(6, TEXT("Sat"));
		m_mot_alarm_week.SetCurSel(0);
		memset(&mot_schedule_time_list, 0, sizeof(jy_dev_show_schedule_time_list_t));
		for (int i = 0; i < mot_alarm_param_list.mot_alarm_list[0].mot_source_param.schedule_time_size; ++i)
		{
			switch (mot_alarm_param_list.mot_alarm_list[0].mot_source_param.schedule_time_list[i].week_day)
			{
			case 0:
				mot_schedule_time_list.show_time_list[0].schedule_time_list[mot_schedule_time_list.show_time_list[0].list_size].week_day = mot_alarm_param_list.mot_alarm_list[0].mot_source_param.schedule_time_list[i].week_day;
				mot_schedule_time_list.show_time_list[0].schedule_time_list[mot_schedule_time_list.show_time_list[0].list_size].start_time = mot_alarm_param_list.mot_alarm_list[0].mot_source_param.schedule_time_list[i].start_time;
				mot_schedule_time_list.show_time_list[0].schedule_time_list[mot_schedule_time_list.show_time_list[0].list_size].end_time = mot_alarm_param_list.mot_alarm_list[0].mot_source_param.schedule_time_list[i].end_time;
				++mot_schedule_time_list.show_time_list[0].list_size;
				break;
			case 1:
				mot_schedule_time_list.show_time_list[1].schedule_time_list[mot_schedule_time_list.show_time_list[1].list_size].week_day = mot_alarm_param_list.mot_alarm_list[0].mot_source_param.schedule_time_list[i].week_day;
				mot_schedule_time_list.show_time_list[1].schedule_time_list[mot_schedule_time_list.show_time_list[1].list_size].start_time = mot_alarm_param_list.mot_alarm_list[0].mot_source_param.schedule_time_list[i].start_time;
				mot_schedule_time_list.show_time_list[1].schedule_time_list[mot_schedule_time_list.show_time_list[1].list_size].end_time = mot_alarm_param_list.mot_alarm_list[0].mot_source_param.schedule_time_list[i].end_time;
				++mot_schedule_time_list.show_time_list[1].list_size;
				break;
			case 2:
				mot_schedule_time_list.show_time_list[2].schedule_time_list[mot_schedule_time_list.show_time_list[2].list_size].week_day = mot_alarm_param_list.mot_alarm_list[0].mot_source_param.schedule_time_list[i].week_day;
				mot_schedule_time_list.show_time_list[2].schedule_time_list[mot_schedule_time_list.show_time_list[2].list_size].start_time = mot_alarm_param_list.mot_alarm_list[0].mot_source_param.schedule_time_list[i].start_time;
				mot_schedule_time_list.show_time_list[2].schedule_time_list[mot_schedule_time_list.show_time_list[2].list_size].end_time = mot_alarm_param_list.mot_alarm_list[0].mot_source_param.schedule_time_list[i].end_time;
				++mot_schedule_time_list.show_time_list[2].list_size;
				break;
			case 3:
				mot_schedule_time_list.show_time_list[3].schedule_time_list[mot_schedule_time_list.show_time_list[3].list_size].week_day = mot_alarm_param_list.mot_alarm_list[0].mot_source_param.schedule_time_list[i].week_day;
				mot_schedule_time_list.show_time_list[3].schedule_time_list[mot_schedule_time_list.show_time_list[3].list_size].start_time = mot_alarm_param_list.mot_alarm_list[0].mot_source_param.schedule_time_list[i].start_time;
				mot_schedule_time_list.show_time_list[3].schedule_time_list[mot_schedule_time_list.show_time_list[3].list_size].end_time = mot_alarm_param_list.mot_alarm_list[0].mot_source_param.schedule_time_list[i].end_time;
				++mot_schedule_time_list.show_time_list[3].list_size;
				break;
			case 4:
				mot_schedule_time_list.show_time_list[4].schedule_time_list[mot_schedule_time_list.show_time_list[4].list_size].week_day = mot_alarm_param_list.mot_alarm_list[0].mot_source_param.schedule_time_list[i].week_day;
				mot_schedule_time_list.show_time_list[4].schedule_time_list[mot_schedule_time_list.show_time_list[4].list_size].start_time = mot_alarm_param_list.mot_alarm_list[0].mot_source_param.schedule_time_list[i].start_time;
				mot_schedule_time_list.show_time_list[4].schedule_time_list[mot_schedule_time_list.show_time_list[4].list_size].end_time = mot_alarm_param_list.mot_alarm_list[0].mot_source_param.schedule_time_list[i].end_time;
				++mot_schedule_time_list.show_time_list[4].list_size;
				break;
			case 5:
				mot_schedule_time_list.show_time_list[5].schedule_time_list[mot_schedule_time_list.show_time_list[5].list_size].week_day = mot_alarm_param_list.mot_alarm_list[0].mot_source_param.schedule_time_list[i].week_day;
				mot_schedule_time_list.show_time_list[5].schedule_time_list[mot_schedule_time_list.show_time_list[5].list_size].start_time = mot_alarm_param_list.mot_alarm_list[0].mot_source_param.schedule_time_list[i].start_time;
				mot_schedule_time_list.show_time_list[5].schedule_time_list[mot_schedule_time_list.show_time_list[5].list_size].end_time = mot_alarm_param_list.mot_alarm_list[0].mot_source_param.schedule_time_list[i].end_time;
				++mot_schedule_time_list.show_time_list[5].list_size;
				break;
			case 6:
				mot_schedule_time_list.show_time_list[6].schedule_time_list[mot_schedule_time_list.show_time_list[6].list_size].week_day = mot_alarm_param_list.mot_alarm_list[0].mot_source_param.schedule_time_list[i].week_day;
				mot_schedule_time_list.show_time_list[6].schedule_time_list[mot_schedule_time_list.show_time_list[6].list_size].start_time = mot_alarm_param_list.mot_alarm_list[0].mot_source_param.schedule_time_list[i].start_time;
				mot_schedule_time_list.show_time_list[6].schedule_time_list[mot_schedule_time_list.show_time_list[6].list_size].end_time = mot_alarm_param_list.mot_alarm_list[0].mot_source_param.schedule_time_list[i].end_time;
				++mot_schedule_time_list.show_time_list[6].list_size;
				break;
			default:break;
			}
		}
		OnCbnSelchangeComboAlarmDate();
	}
	return TRUE;
}

BEGIN_MESSAGE_MAP(CDialogMotionAlarm, CDialogEx)
	ON_CBN_SELCHANGE(IDC_COMBO_ALARM_DATE, &CDialogMotionAlarm::OnCbnSelchangeComboAlarmDate)
	ON_BN_CLICKED(IDOK2, &CDialogMotionAlarm::OnBnClickedOk2)
	ON_BN_CLICKED(IDOK3, &CDialogMotionAlarm::OnBnClickedOk3)
END_MESSAGE_MAP()


static int conversion_time(int src_time, int &res_hours, int &res_min)
{
	res_hours = src_time / 3600;
	res_min = (src_time - (res_hours * 3600)) / 60;
	return 0;
}

void CDialogMotionAlarm::show_date_info(int week, jy_dev_show_schedule_time_list_t *schedule_time_list)
{
	CString strins;
	int start_hours;
	int start_min;
	int end_hours;
	int end_min;
	conversion_time(schedule_time_list->show_time_list[week].schedule_time_list[0].start_time, start_hours, start_min);
	conversion_time(schedule_time_list->show_time_list[week].schedule_time_list[0].end_time, end_hours, end_min);
	strins.Format(_T("%d"), start_hours);
	m_start_time_h1.SetWindowTextA(strins);
	strins.Format(_T("%d"), start_min);
	m_start_time_m1.SetWindowTextA(strins);
	strins.Format(_T("%d"), end_hours);
	m_end_time_h1.SetWindowTextA(strins);
	strins.Format(_T("%d"), end_min);
	m_end_time_m1.SetWindowTextA(strins);
	conversion_time(schedule_time_list->show_time_list[week].schedule_time_list[1].start_time, start_hours, start_min);
	conversion_time(schedule_time_list->show_time_list[week].schedule_time_list[1].end_time, end_hours, end_min);
	strins.Format(_T("%d"), start_hours);
	m_start_time_h2.SetWindowTextA(strins);
	strins.Format(_T("%d"), start_min);
	m_start_time_m2.SetWindowTextA(strins);
	strins.Format(_T("%d"), end_hours);
	m_end_time_h2.SetWindowTextA(strins);
	strins.Format(_T("%d"), end_min);
	m_end_time_m2.SetWindowTextA(strins);
	conversion_time(schedule_time_list->show_time_list[week].schedule_time_list[2].start_time, start_hours, start_min);
	conversion_time(schedule_time_list->show_time_list[week].schedule_time_list[2].end_time, end_hours, end_min);
	strins.Format(_T("%d"), start_hours);
	m_start_time_h3.SetWindowTextA(strins);
	strins.Format(_T("%d"), start_min);
	m_start_time_m3.SetWindowTextA(strins);
	strins.Format(_T("%d"), end_hours);
	m_end_time_h3.SetWindowTextA(strins);
	strins.Format(_T("%d"), end_min);
	m_end_time_m3.SetWindowTextA(strins);
	conversion_time(schedule_time_list->show_time_list[week].schedule_time_list[3].start_time, start_hours, start_min);
	conversion_time(schedule_time_list->show_time_list[week].schedule_time_list[3].end_time, end_hours, end_min);
	strins.Format(_T("%d"), start_hours);
	m_start_time_h4.SetWindowTextA(strins);
	strins.Format(_T("%d"), start_min);
	m_start_time_m4.SetWindowTextA(strins);
	strins.Format(_T("%d"), end_hours);
	m_end_time_h4.SetWindowTextA(strins);
	strins.Format(_T("%d"), end_min);
	m_end_time_m4.SetWindowTextA(strins);
	conversion_time(schedule_time_list->show_time_list[week].schedule_time_list[4].start_time, start_hours, start_min);
	conversion_time(schedule_time_list->show_time_list[week].schedule_time_list[4].end_time, end_hours, end_min);
	strins.Format(_T("%d"), start_hours);
	m_start_time_h5.SetWindowTextA(strins);
	strins.Format(_T("%d"), start_min);
	m_start_time_m5.SetWindowTextA(strins);
	strins.Format(_T("%d"), end_hours);
	m_end_time_h5.SetWindowTextA(strins);
	strins.Format(_T("%d"), end_min);
	m_end_time_m5.SetWindowTextA(strins);
	conversion_time(schedule_time_list->show_time_list[week].schedule_time_list[5].start_time, start_hours, start_min);
	conversion_time(schedule_time_list->show_time_list[week].schedule_time_list[5].end_time, end_hours, end_min);
	strins.Format(_T("%d"), start_hours);
	m_start_time_h6.SetWindowTextA(strins);
	strins.Format(_T("%d"), start_min);
	m_start_time_m6.SetWindowTextA(strins);
	strins.Format(_T("%d"), end_hours);
	m_end_time_h6.SetWindowTextA(strins);
	strins.Format(_T("%d"), end_min);
	m_end_time_m6.SetWindowTextA(strins);
	conversion_time(schedule_time_list->show_time_list[week].schedule_time_list[6].start_time, start_hours, start_min);
	conversion_time(schedule_time_list->show_time_list[week].schedule_time_list[6].end_time, end_hours, end_min);
	strins.Format(_T("%d"), start_hours);
	m_start_time_h7.SetWindowTextA(strins);
	strins.Format(_T("%d"), start_min);
	m_start_time_m7.SetWindowTextA(strins);
	strins.Format(_T("%d"), end_hours);
	m_end_time_h7.SetWindowTextA(strins);
	strins.Format(_T("%d"), end_min);
	m_end_time_m7.SetWindowTextA(strins);
	conversion_time(schedule_time_list->show_time_list[week].schedule_time_list[7].start_time, start_hours, start_min);
	conversion_time(schedule_time_list->show_time_list[week].schedule_time_list[7].end_time, end_hours, end_min);
	strins.Format(_T("%d"), start_hours);
	m_start_time_h8.SetWindowTextA(strins);
	strins.Format(_T("%d"), start_min);
	m_start_time_m8.SetWindowTextA(strins);
	strins.Format(_T("%d"), end_hours);
	m_end_time_h8.SetWindowTextA(strins);
	strins.Format(_T("%d"), end_min);
	m_end_time_m8.SetWindowTextA(strins);
}

void CDialogMotionAlarm::OnCbnSelchangeComboAlarmDate()
{
	int week = m_mot_alarm_week.GetCurSel();
	show_date_info(week, &mot_schedule_time_list);
}

void CDialogMotionAlarm::OnBnClickedOk3()
{
	CString str_tmp;
	int tmp_start_hours;
	int tmp_start_min;
	int tmp_end_hours;
	int tmp_end_min;
	int week = m_mot_alarm_week.GetCurSel();
	memset(&mot_schedule_time_list.show_time_list[week], 0, sizeof(jy_dev_show_schedule_time_t));
	m_start_time_h1.GetWindowText(str_tmp);
	tmp_start_hours = _ttoi(str_tmp);
	m_start_time_m1.GetWindowText(str_tmp);
	tmp_start_min = _ttoi(str_tmp);
	m_end_time_h1.GetWindowText(str_tmp);
	tmp_end_hours = _ttoi(str_tmp);
	m_end_time_m1.GetWindowText(str_tmp);
	tmp_end_min = _ttoi(str_tmp);
	if ((0 != tmp_start_hours) || (0 != tmp_start_min) || (0 != tmp_end_hours) || (0 != tmp_end_min))
	{
		if ((tmp_start_hours * 3600 + tmp_start_min * 60) < ((tmp_end_hours * 3600 + tmp_end_min * 60)))
		{
			mot_schedule_time_list.show_time_list[week].schedule_time_list[0].week_day = week;
			mot_schedule_time_list.show_time_list[week].schedule_time_list[0].start_time = (tmp_start_hours * 3600 + tmp_start_min * 60);
			mot_schedule_time_list.show_time_list[week].schedule_time_list[0].end_time = (tmp_end_hours * 3600 + tmp_end_min * 60);
		}
		else
		{
			MessageBoxA("Start time cannot be later than end time ");
		}
		++mot_schedule_time_list.show_time_list[week].list_size;
	}
	m_start_time_h2.GetWindowText(str_tmp);
	tmp_start_hours = _ttoi(str_tmp);
	m_start_time_m2.GetWindowText(str_tmp);
	tmp_start_min = _ttoi(str_tmp);
	m_end_time_h2.GetWindowText(str_tmp);
	tmp_end_hours = _ttoi(str_tmp);
	m_end_time_m2.GetWindowText(str_tmp);
	tmp_end_min = _ttoi(str_tmp);
	if ((0 != tmp_start_hours) || (0 != tmp_start_min) || (0 != tmp_end_hours) || (0 != tmp_end_min))
	{
		if ((tmp_start_hours * 3600 + tmp_start_min * 60) <= ((tmp_end_hours * 3600 + tmp_end_min * 60)))
		{
			mot_schedule_time_list.show_time_list[week].schedule_time_list[1].week_day = week;
			mot_schedule_time_list.show_time_list[week].schedule_time_list[1].start_time = (tmp_start_hours * 3600 + tmp_start_min * 60);
			mot_schedule_time_list.show_time_list[week].schedule_time_list[1].end_time = (tmp_end_hours * 3600 + tmp_end_min * 60);
		}
		else
		{
			MessageBoxA("Start time cannot be later than end time ");
		}
		++mot_schedule_time_list.show_time_list[week].list_size;
	}
	m_start_time_h3.GetWindowText(str_tmp);
	tmp_start_hours = _ttoi(str_tmp);
	m_start_time_m3.GetWindowText(str_tmp);
	tmp_start_min = _ttoi(str_tmp);
	m_end_time_h3.GetWindowText(str_tmp);
	tmp_end_hours = _ttoi(str_tmp);
	m_end_time_m3.GetWindowText(str_tmp);
	tmp_end_min = _ttoi(str_tmp);
	if ((0 != tmp_start_hours) || (0 != tmp_start_min) || (0 != tmp_end_hours) || (0 != tmp_end_min))
	{
		if ((tmp_start_hours * 3600 + tmp_start_min * 60) <= ((tmp_end_hours * 3600 + tmp_end_min * 60)))
		{
			mot_schedule_time_list.show_time_list[week].schedule_time_list[2].week_day = week;
			mot_schedule_time_list.show_time_list[week].schedule_time_list[2].start_time = (tmp_start_hours * 3600 + tmp_start_min * 60);
			mot_schedule_time_list.show_time_list[week].schedule_time_list[2].end_time = (tmp_end_hours * 3600 + tmp_end_min * 60);
		}
		else
		{
			MessageBoxA("Start time cannot be later than end time ");
		}
		++mot_schedule_time_list.show_time_list[week].list_size;
	}
	m_start_time_h4.GetWindowText(str_tmp);
	tmp_start_hours = _ttoi(str_tmp);
	m_start_time_m4.GetWindowText(str_tmp);
	tmp_start_min = _ttoi(str_tmp);
	m_end_time_h4.GetWindowText(str_tmp);
	tmp_end_hours = _ttoi(str_tmp);
	m_end_time_m4.GetWindowText(str_tmp);
	tmp_end_min = _ttoi(str_tmp);
	if ((0 != tmp_start_hours) || (0 != tmp_start_min) || (0 != tmp_end_hours) || (0 != tmp_end_min))
	{
		if ((tmp_start_hours * 3600 + tmp_start_min * 60) <= ((tmp_end_hours * 3600 + tmp_end_min * 60)))
		{
			mot_schedule_time_list.show_time_list[week].schedule_time_list[3].week_day = week;
			mot_schedule_time_list.show_time_list[week].schedule_time_list[3].start_time = (tmp_start_hours * 3600 + tmp_start_min * 60);
			mot_schedule_time_list.show_time_list[week].schedule_time_list[3].end_time = (tmp_end_hours * 3600 + tmp_end_min * 60);
		}
		else
		{
			MessageBoxA("Start time cannot be later than end time ");
		}
		++mot_schedule_time_list.show_time_list[week].list_size;
	}
	m_start_time_h5.GetWindowText(str_tmp);
	tmp_start_hours = _ttoi(str_tmp);
	m_start_time_m5.GetWindowText(str_tmp);
	tmp_start_min = _ttoi(str_tmp);
	m_end_time_h5.GetWindowText(str_tmp);
	tmp_end_hours = _ttoi(str_tmp);
	m_end_time_m5.GetWindowText(str_tmp);
	tmp_end_min = _ttoi(str_tmp);
	if ((0 != tmp_start_hours) || (0 != tmp_start_min) || (0 != tmp_end_hours) || (0 != tmp_end_min))
	{
		if ((tmp_start_hours * 3600 + tmp_start_min * 60) <= ((tmp_end_hours * 3600 + tmp_end_min * 60)))
		{
			mot_schedule_time_list.show_time_list[week].schedule_time_list[4].week_day = week;
			mot_schedule_time_list.show_time_list[week].schedule_time_list[4].start_time = (tmp_start_hours * 3600 + tmp_start_min * 60);
			mot_schedule_time_list.show_time_list[week].schedule_time_list[4].end_time = (tmp_end_hours * 3600 + tmp_end_min * 60);
		}
		else
		{
			MessageBoxA("Start time cannot be later than end time ");
		}
		++mot_schedule_time_list.show_time_list[week].list_size;
	}
	m_start_time_h6.GetWindowText(str_tmp);
	tmp_start_hours = _ttoi(str_tmp);
	m_start_time_m6.GetWindowText(str_tmp);
	tmp_start_min = _ttoi(str_tmp);
	m_end_time_h6.GetWindowText(str_tmp);
	tmp_end_hours = _ttoi(str_tmp);
	m_end_time_m6.GetWindowText(str_tmp);
	tmp_end_min = _ttoi(str_tmp);
	if ((0 != tmp_start_hours) || (0 != tmp_start_min) || (0 != tmp_end_hours) || (0 != tmp_end_min))
	{
		if ((tmp_start_hours * 3600 + tmp_start_min * 60) <= ((tmp_end_hours * 3600 + tmp_end_min * 60)))
		{
			mot_schedule_time_list.show_time_list[week].schedule_time_list[5].week_day = week;
			mot_schedule_time_list.show_time_list[week].schedule_time_list[5].start_time = (tmp_start_hours * 3600 + tmp_start_min * 60);
			mot_schedule_time_list.show_time_list[week].schedule_time_list[5].end_time = (tmp_end_hours * 3600 + tmp_end_min * 60);
		}
		else
		{
			MessageBoxA("Start time cannot be later than end time ");
		}
		++mot_schedule_time_list.show_time_list[week].list_size;
	}
	m_start_time_h7.GetWindowText(str_tmp);
	tmp_start_hours = _ttoi(str_tmp);
	m_start_time_m7.GetWindowText(str_tmp);
	tmp_start_min = _ttoi(str_tmp);
	m_end_time_h7.GetWindowText(str_tmp);
	tmp_end_hours = _ttoi(str_tmp);
	m_end_time_m7.GetWindowText(str_tmp);
	tmp_end_min = _ttoi(str_tmp);
	if ((0 != tmp_start_hours) || (0 != tmp_start_min) || (0 != tmp_end_hours) || (0 != tmp_end_min))
	{
		if ((tmp_start_hours * 3600 + tmp_start_min * 60) <= ((tmp_end_hours * 3600 + tmp_end_min * 60)))
		{
			mot_schedule_time_list.show_time_list[week].schedule_time_list[6].week_day = week;
			mot_schedule_time_list.show_time_list[week].schedule_time_list[6].start_time = (tmp_start_hours * 3600 + tmp_start_min * 60);
			mot_schedule_time_list.show_time_list[week].schedule_time_list[6].end_time = (tmp_end_hours * 3600 + tmp_end_min * 60);
		}
		else
		{
			MessageBoxA("Start time cannot be later than end time ");
		}
		++mot_schedule_time_list.show_time_list[week].list_size;
	}
	m_start_time_h8.GetWindowText(str_tmp);
	tmp_start_hours = _ttoi(str_tmp);
	m_start_time_m8.GetWindowText(str_tmp);
	tmp_start_min = _ttoi(str_tmp);
	m_end_time_h8.GetWindowText(str_tmp);
	tmp_end_hours = _ttoi(str_tmp);
	m_end_time_m8.GetWindowText(str_tmp);
	tmp_end_min = _ttoi(str_tmp);
	if ((0 != tmp_start_hours) || (0 != tmp_start_min) || (0 != tmp_end_hours) || (0 != tmp_end_min))
	{
		if ((tmp_start_hours * 3600 + tmp_start_min * 60) <= ((tmp_end_hours * 3600 + tmp_end_min * 60)))
		{
			mot_schedule_time_list.show_time_list[week].schedule_time_list[7].week_day = week;
			mot_schedule_time_list.show_time_list[week].schedule_time_list[7].start_time = (tmp_start_hours * 3600 + tmp_start_min * 60);
			mot_schedule_time_list.show_time_list[week].schedule_time_list[7].end_time = (tmp_end_hours * 3600 + tmp_end_min * 60);
		}
		else
		{
			MessageBoxA("Start time cannot be later than end time ");
		}
		++mot_schedule_time_list.show_time_list[week].list_size;
	}
}

void CDialogMotionAlarm::OnBnClickedOk2()
{
	CString str_tmp;
	int schedule_size = 0;
	char *p_param = NULL;
	mot_alarm_param_list.mot_alarm_list[0].mot_source_param.enable_flag = 0;
	if (((CButton*)GetDlgItem(IDC_CHECK_MOT_ALARM_FLAG))->GetCheck() == TRUE)
	{
		mot_alarm_param_list.mot_alarm_list[0].mot_source_param.enable_flag = 1;
	}
	mot_alarm_param_list.mot_alarm_list[0].mot_source_param.mot_analysis_flag = 0;
	if (((CButton*)GetDlgItem(IDC_CHECK_MOT_ANALYSIS_FLAG))->GetCheck() == TRUE)
	{
		mot_alarm_param_list.mot_alarm_list[0].mot_source_param.mot_analysis_flag = 1;
	}
	m_mot_alarm_interval.GetWindowText(str_tmp);
	mot_alarm_param_list.mot_alarm_list[0].mot_source_param.alarm_interval = _ttoi(str_tmp);
	mot_alarm_param_list.mot_alarm_list[0].mot_source_param.mot_detect_param.sensitivity = m_mot_sensitivity.GetCurSel() + 1;

	for (int i = 0; i < 7; ++i)
	{
		for (int j = 0; j < mot_schedule_time_list.show_time_list[i].list_size; ++j)
		{
			mot_alarm_param_list.mot_alarm_list[0].mot_source_param.schedule_time_list[schedule_size].week_day = mot_schedule_time_list.show_time_list[i].schedule_time_list[j].week_day;
			mot_alarm_param_list.mot_alarm_list[0].mot_source_param.schedule_time_list[schedule_size].start_time = mot_schedule_time_list.show_time_list[i].schedule_time_list[j].start_time;
			mot_alarm_param_list.mot_alarm_list[0].mot_source_param.schedule_time_list[schedule_size].end_time = mot_schedule_time_list.show_time_list[i].schedule_time_list[j].end_time;
			++schedule_size;
		}
	}
	mot_alarm_param_list.mot_alarm_list[0].mot_source_param.schedule_time_size = schedule_size;
	UINT i = 0;
	i = MessageBoxA(_T("Are you sure you want to set motion detection alarm?"), _T("Prompt"), MB_YESNO | MB_ICONQUESTION);
	if (IDYES == i)
	{
		pack_json_mot_alarm(&mot_alarm_param_list, &p_param);
		int nRet = sdks_set_mot_param(m_handle, m_chn_option, p_param);
		if (nRet) {
			MessageBoxA("Set disk alarm param fail!");
		}
	}
}